import React, { useState } from 'react';
import { Input, Space, Button } from 'antd';

const { TextArea } = Input;

export const AddInput:React.FC<{
    setItem: (word:string) => void;
    placeholder:string;
}> = ({ setItem, placeholder }) => {
    const [inputValue, setInputValue] = useState('')
    
    const onChange = (e: React.ChangeEvent<HTMLInputElement | HTMLTextAreaElement>) => {
        setInputValue(e.target.value)
    }

    
        
    return (
        <>
            <div>
            <Space.Compact style={{ width: '100%', marginBottom: '10px' }}>
                <TextArea showCount onChange={onChange} placeholder={placeholder} />
            </Space.Compact>
            <Space.Compact style={{ width: '100%' }}>
                <Button style={{ width: '100%', margin: '15px 0px' }} onClick={() => {setItem(inputValue)}} type="primary">Add</Button>
            </Space.Compact>
            </div>
        </>
    )
}