import React, { useEffect, useState } from 'react';
import { CopyOutlined, DeleteOutlined } from '@ant-design/icons';
import { Input } from 'antd';
import { AddInput } from './Tools';
const { Search } = Input;

export const TemplatesWidget:React.FC = () => {
    const [templates, setTemplates] = useState<string[]>([])
    const [filteredTemplates, setFilteredTemplates] = useState<string[]>([])

    const [filterWord, setFilterWord] = useState('')

    useEffect(() => {
        chrome.storage.local.get(["templates"]).then((result) => {
            setTemplates(result.templates)
            setFilteredTemplates(result.templates)
        });
    }, [])  

    useEffect(() => {
        const newFilteredTemplates = templates.filter(temp => temp.toLowerCase().includes(filterWord.toLowerCase()))
        console.log(newFilteredTemplates)
        setFilteredTemplates(newFilteredTemplates)
    }, [filterWord, templates]) 

    const onSearch = (search:string) => {
        console.log(search) 
        setFilterWord(search)
    }

    const addItem = (template:string) => {
        const newTemplateList = [...templates, template]
        setTemplates(newTemplateList)
        chrome.storage.local.set({templates: newTemplateList})
    }

    
    const deleteItem = (templateIndex:number) => {
        const newTemplates = templates.filter((template, index) => { return index!==templateIndex})
        setTemplates(newTemplates)
        chrome.storage.local.set({templates: newTemplates})
    }
      

    const copyToClipboard = (text:string) => {
        navigator.clipboard.writeText(text).then(() => {
          console.log('Text copied to clipboard');
        }).catch(err => {
          console.error('Failed to copy: ', err);
        });
      }
      
        
    return (
        <>
            <div>
                <p className="section_banner">Templates</p>
                <AddInput placeholder='Add Template' setItem={addItem} />
                <Search placeholder="Filter" onSearch={onSearch} style={{ width: '100%' }} />
                {
                    filteredTemplates.length &&
                    filteredTemplates.map((template, index) => {
                        return <div className="custom-border">
                            <div key={index} className="template_section template">
                                <span>{template}</span>
                                <div style={{display: 'flex', width: '10%', flexDirection: 'column', justifyContent: 'space-between', alignItems: 'center'}}>
                                    <CopyOutlined style={{fontSize: '20px'}} onClick={() => {copyToClipboard(template)}}/>
                                    <DeleteOutlined style={{fontSize: '15px'}} onClick={() => {deleteItem(index);}}/>
                                </div>
                            </div>
                        </div>
                    })
                }
            </div>
        </>
    )
}