import React, {useEffect, useState } from 'react';
import { LinksWidget } from './LinksWidget';
import { TemplatesWidget } from './TemplatesWidget';
import './sidepanel.scss'

export const SidePanelPage:React.FC = () => {
    const [extensionTitle, setExtensionTitle] = useState('')
    useEffect(() => {
        var manifestData = chrome.runtime.getManifest();
  
        // Extract the "name" property from the manifest data
        var extensionName = manifestData.name;
        setExtensionTitle(extensionName)
    }, [])
        
    return (
        <>
            <div>
                <div className='heading_section'>
                    <div className='mainHeading'>
                        <img src="../assets/logo.png" alt="" />
                        <h1 className='head_title'>{extensionTitle}</h1>
                    </div>
                </div>
            
                <LinksWidget/>
                <TemplatesWidget/>
            </div>
        </>
    )
}