import React, { useEffect, useState } from 'react';
import { CopyOutlined,DeleteOutlined } from '@ant-design/icons';
import { AddInput } from './Tools';

export const LinksWidget:React.FC = () => {
    const [links, setLinks] = useState<string[]>([])

    useEffect(() => {
        chrome.storage.local.get(["links"]).then((result) => {
            setLinks(result.links)
        });
    }, [])  

    const copyToClipboard = (text:string) => {
        navigator.clipboard.writeText(text).then(() => {
          console.log('Text copied to clipboard');
        }).catch(err => {
          console.error('Failed to copy: ', err);
        });
      }

    const addItem = (link:string) => {
        const newLinkList = [...links, link]
        setLinks(newLinkList)
        chrome.storage.local.set({links: newLinkList})
    }

    const deleteItem = (linkIndex:number) => {
        const newLinks = links.filter((link, index) => { return index!==linkIndex})
        setLinks(newLinks)
        chrome.storage.local.set({links: newLinks})
    }
      
        
    return (
        <>
            <div>
                <p className="section_banner">Links</p>
                <AddInput placeholder='Add Link' setItem={addItem} />
                {
                    links.length &&
                    links.map((link, index) => {
                        return <div key={link} className="link_section">
                            <div style={{display: 'flex', justifyContent: 'center', alignItems: 'center'}}>
                                <DeleteOutlined style={{fontSize: '15px', marginRight: '10px'}} onClick={() => {deleteItem(index);}}/>
                                <a href={link}>{link}</a>
                            </div>
                            <div style={{display: 'flex', width: '10%', justifyContent: 'space-between'}}>
                                <CopyOutlined style={{fontSize: '20px'}} size={300} onClick={() => {copyToClipboard(link)}}/>
                            </div>
                        </div>
                    })
                }
            </div>
        </>
    )
}